<?php
session_start();
include ('conexion/config.php');
include ('php/funciones.php');
include ('php/funciones_clientes.php');
include ('php/funciones_clientes2.php');

include ('php/funciones_head.php');

if (CheckSesion($_SESSION, 'emailUser') == "1") {

    $session_var = VariablesSession($_SESSION, ['nameUser', 'emailUser', 'UserAdmin']);
    ?>
    <!DOCTYPE html>
    <html lang="es">

    <?php MostrarHead(1); ?>
    <!--"/css2/estilo_cliente2.css" -->

    <body>

        <div class="header sticky">
            <div class="container">
                <div>
                    <a href="#home" class="header-titulo">Clientes</a>
                </div>
                <div>
                    <button class="boton-menu" onclick="openFormNuevoCliente()">
                        <a href="#">Nuevo Cliente</a>
                    </button>
                </div>

                <nav class="menu-principal" data-navbar>

                    <div class="nombre-sesion">
                        <?php
                        $texto_admin = VarBoolIntToTexto($session_var[2], " (A)", "");
                        echo $session_var[0] . $texto_admin;
                        ?>
                    </div>
                    <div>
                        <button id="boton-cliente" class="boton-menu" aria-label="Toggle Menu" title="Toggle Menu">
                            <a href="#">Ver Clientes</a>
                        </button>
                    </div>
                    <div>
                        <button id="boton-salir" class="boton-menu" aria-label="Toggle Menu" title="Toggle Menu">
                            <a href="login/salirSesion.php">Salir</a>
                        </button>
                    </div>
                </nav>
            </div>
        </div>

        <?php AñadirCliente(); ?>

        <div class="left" id="columna-izquierda">
            <div class="header sticky">
                <div class="container">
                    <nav class="menu-principal" data-navbar>

                        <?php
                        if (isset($_GET["chk_busq_leads"]) == "" and isset($_GET["chk_busq_cli"]) == "") {
                            $seleccion_leads = 'checked';
                            $seleccion_clientes = 'checked';
                            $selec_chk = 0;
                        } else if (isset($_GET["chk_busq_leads"]) == "" and isset($_GET["chk_busq_cli"]) != "") {
                            $seleccion_leads = '';
                            $seleccion_clientes = 'checked';
                            $selec_chk = 1;
                        } else if (isset($_GET["chk_busq_leads"]) != "" and isset($_GET["chk_busq_cli"]) == "") {
                            $seleccion_leads = 'checked';
                            $seleccion_clientes = '';
                            $selec_chk = 2;
                        } else {
                            $seleccion_leads = 'checked';
                            $seleccion_clientes = 'checked';
                            $selec_chk = 0;
                        }

                        $texto_bus = '';
                        if (isset($_GET["busq"]) != "") {
                            $texto_bus = $_GET["busq"];
                        }
                        ?>

                        <form id="buscarCheck" action="clientes4.php" class="">
                            <div class="checkbox-buscar">
                                <input type="checkbox" name="chk_busq_leads" id="cbox1" value="chk_leads" <?php echo $seleccion_leads; ?> onchange="document.getElementById('buscarCheck').submit()" />
                                <label for="cbox1" type="submit">Leads</label>
                                <input type="checkbox" name="chk_busq_cli" id="cbox2" value="chk_clientes" <?php echo $seleccion_clientes; ?> onchange="document.getElementById('buscarCheck').submit()" />
                                <label for="cbox2" type="submit">Clientes</label>
                            </div>

                            <input type="text" placeholder="" name="busq" value="<?php echo $texto_bus; ?>" required>
                            <button type="submit" class="boton-menu">Buscar</button>
                        </form>

                        <form action="clientes4.php" class="">



                        </form>
                    </nav>
                </div>
            </div>
            <div class="container">
                <?php CargarListaClientes2($con, $_GET["busq"], $selec_chk); ?>
            </div>
        </div>

        <div class="left-boton" id="columna-izquierda-boton" style="display:none;">
            <div class="header sticky">
                <div class="container">
                    <nav class="menu-principal" data-navbar>
                        <form action="clientes4.php" class="">
                            <input type="text" placeholder="" name="busq" value="" required>
                            <button type="submit" class="boton-menu">Buscar</button>
                        </form>
                    </nav>
                </div>
            </div>
            <div class="container">
                <?php CargarListaClientes2($con, $_GET["busq"], $selec_chk); ?>
            </div>
        </div>


        <div class="right" id="columna-derecha">
            <div class="header sticky">
                <?php
                $cliente = GetInfoCliente($con, $_GET["id"]);

                if ($cliente['cli_id'] != "") {
                    MostrarCabeceraTituloCliente2($con, $cliente['cli_id']);
                    ?>                   

                    <?php
                } else {
                    echo "<h2>Selecciona un cliente</h2>";
                }
                ?>
            </div>

            <?php
            if ($cliente['cli_id'] != "") {
                ?>

                <div class="cuerpo">
                    <div class="cuerpo-izq">
                        <?php
                        MostrarInfoCliente2($con, $cliente['cli_id']);
                        ?>
                        <hr class="barra-separadora">
                        <div class="lista-ofertas">
                            <h3 class="titulo-lista-ofertas">OFERTAS</h3>
                            <button class="añadir-contacto" onclick="openFormNuevaOferta()">Añadir Oferta</button>
                            <?php
                                CargarListaOfertas($con, $cliente['cli_id']);
                                AñadirOferta($cliente['cli_id']);
                            ?>
                        </div>

                    </div>
                    <div class="cuerpo-izq">
                        <div class="tabset">
                            <!-- Tab 1 -->
                            <input type="radio" name="tabset" id="tab1" aria-controls="contactos" checked>
                            <label for="tab1">Contactos</label>
                            <!-- Tab 2 -->
                            <input type="radio" name="tabset" id="tab2" aria-controls="acciones">
                            <label for="tab2">Acciones</label>


                            <div class="tab-panels">
                                <section id="contactos" class="tab-panel">
                                    <button class="añadir-contacto" onclick="openFormNuevoContacto()">Añadir Contacto</button>

                                    <?php
                                    CargarListaContactos2($con, $cliente['cli_id']);
                                    AñadirContacto($cliente['cli_id']);
                                    ?>
                                </section>
                                <section id="acciones" class="tab-panel">
                                    <?php
                                    if (ClienteTieneContactos($con, $cliente['cli_id']) > 0) {
                                        echo '<button class="añadir-contacto" onclick="openFormNuevaAccion()">Añadir Acción</button>';
                                        AñadirAccion($con, $cliente['cli_id']);
                                    }
                                    CargarListaAcciones2($con, $cliente['cli_id']);
                                    ?>
                                </section>

                            </div>

                        </div>
                    </div>
                </div>
                <?php
            }
            ?>
    </body>

    <script>

        var colIzq = document.getElementById('columna-izquierda-boton');

        const boton = document.getElementById("boton-cliente");
        boton.addEventListener("click", () => {
            if (colIzq.style.display == 'none') {
                colIzq.style.display = 'block';
            } else {
                colIzq.style.display = 'none';
            }
        });



        jQuery(document).ready(function ($) {
            //open popup
            $('.modificar').on('click', function (event) {
                event.preventDefault();
                $('.cd-popup').addClass('is-visible');
            });

            //close popup
            $('.cd-popup').on('click', function (event) {
                if ($(event.target).is('.cd-popup-close') || $(event.target).is('.cd-popup')) {
                    event.preventDefault();
                    $(this).removeClass('is-visible');
                }
            });
            //close popup when clicking the esc keyboard button
            $(document).keyup(function (event) {
                if (event.which == '27') {
                    $('.cd-popup').removeClass('is-visible');
                }
            });
        });


        jQuery(document).ready(function ($) {
            //open popup
            $('.añadir-contacto').on('click', function (event) {
                event.preventDefault();
                $('.cd-popup2').addClass('is-visible');
            });

            //close popup
            $('.cd-popup2').on('click', function (event) {
                if ($(event.target).is('.cd-popup2-close') || $(event.target).is('.cd-popup2')) {
                    event.preventDefault();
                    $(this).removeClass('is-visible');
                }
            });
            //close popup when clicking the esc keyboard button
            $(document).keyup(function (event) {
                if (event.which == '27') {
                    $('.cd-popup2').removeClass('is-visible');
                }
            });
        });


        function openFormNuevoCliente() {
            var element = document.getElementById("myFormNuevoCliente");
            element.classList.add("is-visible");
        }

        function openFormNuevo() {
            var element = document.getElementById("myFormNuevo");
            element.classList.add("is-visible");
        }

        function openFormContacto(idCont) {
            var element = document.getElementById("myFormContacto" + idCont);
            element.classList.add("is-visible");
        }

        function openFormNuevoContacto() {
            var element = document.getElementById("myFormNuevoContacto");
            element.classList.add("is-visible");
        }

        function openFormAccion(idAcc) {
            var element = document.getElementById("myFormAccion" + idAcc);
            element.classList.add("is-visible");
        }

        function openFormNuevaAccion() {
            var element = document.getElementById("myFormNuevAccion");
            element.classList.add("is-visible");
        }

        function openFormNuevaOferta() {
            var element = document.getElementById("myFormNuevaOferta");
            element.classList.add("is-visible");
        }

        function openFormOferta(idOf) {
            var element = document.getElementById("myFormOferta" + idOf);
            element.classList.add("is-visible");
        }

        
    </script>

    </html>

    <?php

} else {
    header("location:login/login.php");
}